#include<bits/stdc++.h>
typedef long long ll;
const int MAXN = 100009;
const int MAXM = 200000;
using namespace std;
typedef pair<int, int>pii;

vector<bool> visited(MAXN, false);
int n, m, q;

int l;
vector<vector<int>> adj;

ll timer;
vector<ll> tin, tout;
vector<vector<int>> up;

void dfs(int v, int p)
{
    tin[v] = ++timer;
    up[v][0] = p;
    for (int i = 1; i <= l; ++i)
        up[v][i] = up[up[v][i-1]][i-1];

    for (int u : adj[v]) {
        if (u != p)
            dfs(u, v);
    }

    tout[v] = ++timer;
}

bool is_ancestor(int u, int v)
{
    return tin[u] <= tin[v] && tout[u] >= tout[v];
}

int lca(int u, int v)
{
    if (is_ancestor(u, v))
        return u;
    if (is_ancestor(v, u))
        return v;
    for (int i = l; i >= 0; --i) {
        if (!is_ancestor(up[u][i], v))
            u = up[u][i];
    }
    return up[u][0];
}


void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans)
{
    n = N;
    m = M;
    q = Q;
    adj.resize(N+1);

    for(int i = 1; i<=M; i++)
    {
        adj[U[i]].push_back(V[i]);
        adj[V[i]].push_back(U[i]);
    }

    vector<int>distance(MAXN, 1e9);
    distance[1]=0;
    queue<int>q;
    q.push(1);
    while(!q.empty())
    {
        int tr = q.front();
        q.pop();
        if(visited[tr])continue;
        visited[tr]=true;

        for(auto u:adj[tr])
        {
            if(distance[u]>distance[tr]+1)
            {
                distance[u]=distance[tr]+1;
                q.push(u);
            }
        }
    }

    tin.assign(N+1,0);
    tout.assign(N+1,0);
    timer = 0;
    l = ceil(log2(N+1));
    up.assign(N+1, vector<int>(l + 1));
    dfs(1, 1);


    for(int i=1;i<=Q;i++)
    {
        int x = X[i], y = Y[i];
        Ans[i]=distance[lca(x, y)]+1;
    }
}